"""
Simplified example script for calling the Blue Triangle API for a Content Security Policy
Prints out the Content Security Policy for the Specified ID and Version
See the extended example in csp_api_example.py for more robust functionality
"""

import requests
import json

# Site Prefix is required for the CSP Endpoint
site_prefix = 'examplesite'

# Request Header fields available in the Blue Triangle Portal
# Under the User Menu -> View Profile page
request_headers = {
  'X-API-Email': 'example@bluetriangletech.com',
  'X-API-Key': 'abcd1234',
  'Content-Type': 'application/json'
}

# Blue Triangle's API Endpoint for Content Security Policies
btt_endpoint_url = 'https://api.bluetriangletech.com/content-security-policies?prefix=' + site_prefix

# Issue the GET request to the Blue Triangle API
api_response = requests.request("GET", btt_endpoint_url, headers=request_headers)
csp_data_dict = json.loads(api_response.text)

# Prints each CSP Name, CSP Version, and CSP ID
for csp in csp_data_dict:
    print("CSP Name: '%s', CSP Version: %s, CSP ID: %s" % (csp['name'], csp['id'], csp['version']))

# Specify a CSP ID and CSP Version to print out the Content Security Policy alone
csp_id = '12345'
csp_version = '1'

for csp in csp_data_dict:
    if csp_id == csp['id'] and csp_version == csp['version']:
        print(csp['responseHeader'])
